/*
 * Decompiled with CFR 0.152.
 */
package com.datangMeeting.web.controller.web;

import com.datangMeeting.common.core.domain.BaseDto;
import com.datangMeeting.common.core.domain.JsonResponse;
import com.datangMeeting.system.domain.dto.AdminDmsMeetingDto;
import com.datangMeeting.system.domain.dto.DmsMeetingDto;
import com.datangMeeting.system.domain.vo.DmsMeetingVo;
import com.datangMeeting.system.service.AdminService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u540e\u53f0\u4f1a\u8bae"})
@RestController
@RequestMapping(value={"/admin/meeting"})
public class AdminController {
    private static final Logger log = LoggerFactory.getLogger(AdminController.class);
    @Resource
    private AdminService adminService;

    @ApiOperation(value="\u67e5\u8be2\u4f1a\u8bae")
    @PostMapping(value={"/list"})
    public JsonResponse<PageInfo<DmsMeetingVo.DmsMeetingResultVo>> list(@RequestBody @Validated BaseDto<AdminDmsMeetingDto.QueryMeeting> dto) {
        if (dto.getPageNum() > 0) {
            PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        }
        return JsonResponse.ok((Object)new PageInfo(this.adminService.list((AdminDmsMeetingDto.QueryMeeting)dto.getParam())));
    }

    @ApiOperation(value="\u67e5\u8be2\u4f1a\u8bae\u8be6\u60c5")
    @PostMapping(value={"/details"})
    public JsonResponse<DmsMeetingVo.DmsMeetingDetail> details(@RequestBody @Validated BaseDto<DmsMeetingDto.QueryMeetingDetail> dto) {
        return JsonResponse.ok((Object)this.adminService.details((DmsMeetingDto.QueryMeetingDetail)dto.getParam()));
    }

    @ApiOperation(value="\u65b0\u589e\u4fee\u6539\u4f1a\u8bae")
    @PostMapping(value={"/add"})
    public JsonResponse<Integer> add(@RequestBody @Validated AdminDmsMeetingDto.AddMeeting dto) {
        this.adminService.add(dto);
        return JsonResponse.ok();
    }

    @ApiOperation(value="\u67e5\u8be2\u4f1a\u8bae")
    @PostMapping(value={"/delete"})
    public JsonResponse<Integer> delete(@RequestBody @Validated AdminDmsMeetingDto.Delete dto) {
        this.adminService.delete(dto);
        return JsonResponse.ok();
    }

    @ApiOperation(value="\u65b0\u589e/\u4fee\u6539\u4f1a\u8bae\u8be6\u60c5")
    @PostMapping(value={"/addMeetingInfo"})
    public JsonResponse<Integer> addMeetingInfo(@RequestBody @Validated AdminDmsMeetingDto.AddMeetingInfo dto) {
        this.adminService.addMeetingInfo(dto);
        return JsonResponse.ok();
    }

    @ApiOperation(value="\u5220\u9664\u4f1a\u8bae\u8be6\u60c5")
    @PostMapping(value={"/deleteMeetingInfo"})
    public JsonResponse<Integer> deleteMeetingInfo(@RequestBody @Validated AdminDmsMeetingDto.DeleteMeetingInfo dto) {
        this.adminService.deleteMeetingInfo(dto);
        return JsonResponse.ok();
    }

    @ApiOperation(value="\u6dfb\u52a0\u4f1a\u8bae\u4eba")
    @PostMapping(value={"/addMeetingUser"})
    public JsonResponse<Integer> addMeetingUser(@RequestBody @Validated AdminDmsMeetingDto.MeetingUserDto dto) {
        this.adminService.addMeetingUser(dto.getMeetingId(), dto.getUsernameList());
        return JsonResponse.ok();
    }
}

