/*
 * Decompiled with CFR 0.152.
 */
package com.datangMeeting.system.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.IdUtil;
import com.datangMeeting.common.utils.SecurityUtils;
import com.datangMeeting.system.domain.dto.AdminDmsMeetingDto;
import com.datangMeeting.system.domain.dto.DmsMeetingDto;
import com.datangMeeting.system.domain.po.DmsMeeting;
import com.datangMeeting.system.domain.po.DmsMeetingExample;
import com.datangMeeting.system.domain.po.DmsMeetingInfo;
import com.datangMeeting.system.domain.po.DmsMeetingInfoExample;
import com.datangMeeting.system.domain.po.DmsMeetingUser;
import com.datangMeeting.system.domain.po.DmsMeetingUserExample;
import com.datangMeeting.system.domain.vo.DmsMeetingVo;
import com.datangMeeting.system.persist.dao.DmsMeetingDao;
import com.datangMeeting.system.persist.mapper.DmsMeetingInfoMapper;
import com.datangMeeting.system.persist.mapper.DmsMeetingMapper;
import com.datangMeeting.system.persist.mapper.DmsMeetingUserMapper;
import com.datangMeeting.system.service.AdminService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class AdminServiceImpl
implements AdminService {
    @Resource
    private DmsMeetingMapper dmsMeetingMapper;
    @Resource
    private DmsMeetingDao dmsMeetingDao;
    @Resource
    private DmsMeetingInfoMapper dmsMeetingInfoMapper;
    @Resource
    private DmsMeetingUserMapper dmsMeetingUserMapper;

    @Override
    public void add(AdminDmsMeetingDto.AddMeeting dto) {
        if (dto.getId() == null) {
            DmsMeeting dmsMeeting = (DmsMeeting)BeanUtil.copyProperties((Object)dto, DmsMeeting.class, (String[])new String[0]);
            dmsMeeting.setCreateBy(SecurityUtils.getUsername());
            dmsMeeting.setDelFlag((byte)0);
            dmsMeeting.setCreateTime(new Date());
            dmsMeeting.setId(IdUtil.getSnowflakeNextId());
            this.dmsMeetingMapper.insertSelective(dmsMeeting);
            if (CollUtil.isNotEmpty(dto.getUsernameList())) {
                for (String username : dto.getUsernameList()) {
                    DmsMeetingUser dmsMeetingUser = new DmsMeetingUser();
                    dmsMeetingUser.setId(IdUtil.getSnowflakeNextId());
                    dmsMeetingUser.setMeetingId(dmsMeeting.getId());
                    dmsMeetingUser.setUsername(username);
                    dmsMeetingUser.setCreateBy(SecurityUtils.getUsername());
                    dmsMeetingUser.setCreateTime(new Date());
                    this.dmsMeetingUserMapper.insertSelective(dmsMeetingUser);
                }
            }
        } else {
            DmsMeeting dmsMeeting = (DmsMeeting)BeanUtil.copyProperties((Object)dto, DmsMeeting.class, (String[])new String[0]);
            dmsMeeting.setUpdateBy(SecurityUtils.getUsername());
            dmsMeeting.setUpdateTime(new Date());
            this.dmsMeetingMapper.updateByPrimaryKeySelective(dmsMeeting);
            if (CollUtil.isNotEmpty(dto.getUsernameList())) {
                this.addMeetingUser(dto.getId(), dto.getUsernameList());
            }
        }
    }

    @Override
    public void delete(AdminDmsMeetingDto.Delete dto) {
        DmsMeetingExample dmsMeetingExample = new DmsMeetingExample();
        dmsMeetingExample.createCriteria().andIdIn((List)dto.getIdList());
        DmsMeeting dmsMeeting = new DmsMeeting();
        dmsMeeting.setDelFlag((byte)1);
        this.dmsMeetingMapper.updateByExampleSelective(dmsMeeting, dmsMeetingExample);
    }

    @Override
    public List<DmsMeetingVo.DmsMeetingResultVo> list(AdminDmsMeetingDto.QueryMeeting dto) {
        List<DmsMeetingVo.DmsMeetingResultVo> dmsMeetingResultVos = this.dmsMeetingDao.adminList(dto.getTitle(), SecurityUtils.getUserId(), SecurityUtils.getUsername());
        if (CollUtil.isNotEmpty(dmsMeetingResultVos)) {
            for (DmsMeetingVo.DmsMeetingResultVo dmsMeetingResultVo : dmsMeetingResultVos) {
                DmsMeetingUserExample dmsMeetingUserExample = new DmsMeetingUserExample();
                dmsMeetingUserExample.createCriteria().andDelFlagEqualTo((byte)0).andMeetingIdEqualTo(dmsMeetingResultVo.getId());
                List<DmsMeetingUser> dmsMeetingUsers = this.dmsMeetingUserMapper.selectByExample(dmsMeetingUserExample);
                if (!CollUtil.isNotEmpty(dmsMeetingUsers)) continue;
                dmsMeetingResultVo.setUsernameList(dmsMeetingUsers.stream().map(DmsMeetingUser::getUsername).collect(Collectors.toList()));
            }
        }
        return dmsMeetingResultVos;
    }

    @Override
    public DmsMeetingVo.DmsMeetingDetail details(DmsMeetingDto.QueryMeetingDetail dto) {
        List<DmsMeetingVo.DmsMeetingDetail.DmsMeetingInfoVo> dmsMeetingInfoVos;
        DmsMeetingVo.DmsMeetingDetail dmsMeetingDetail = new DmsMeetingVo.DmsMeetingDetail();
        DmsMeetingInfoExample dmsMeetingInfoExample = new DmsMeetingInfoExample();
        DmsMeetingInfoExample.Criteria criteria = dmsMeetingInfoExample.createCriteria().andDelFlagEqualTo((byte)0);
        if (dto.getMeetingId() != null) {
            criteria.andMeetingIdEqualTo(dto.getMeetingId());
        }
        if (CollUtil.isEmpty(dmsMeetingInfoVos = this.dmsMeetingDao.queryInfo(dto.getMeetingId()))) {
            return dmsMeetingDetail;
        }
        ArrayList<DmsMeetingVo.DmsMeetingDetail.DmsMeetingInfoVo> rootNodes = new ArrayList<DmsMeetingVo.DmsMeetingDetail.DmsMeetingInfoVo>();
        for (DmsMeetingVo.DmsMeetingDetail.DmsMeetingInfoVo info : dmsMeetingInfoVos) {
            if (info.getParentId() != 0L) continue;
            rootNodes.add(info);
        }
        for (DmsMeetingVo.DmsMeetingDetail.DmsMeetingInfoVo rootNode : rootNodes) {
            this.buildTree(rootNode, dmsMeetingInfoVos);
        }
        dmsMeetingDetail.setInfos(rootNodes);
        return dmsMeetingDetail;
    }

    @Override
    public void addMeetingInfo(AdminDmsMeetingDto.AddMeetingInfo dto) {
        DmsMeetingInfo dmsMeetingInfo = (DmsMeetingInfo)BeanUtil.copyProperties((Object)dto, DmsMeetingInfo.class, (String[])new String[0]);
        if (dto.getId() == null) {
            dmsMeetingInfo.setCreateBy(SecurityUtils.getUsername());
            dmsMeetingInfo.setDelFlag((byte)0);
            dmsMeetingInfo.setCreateTime(new Date());
            dmsMeetingInfo.setId(IdUtil.getSnowflakeNextId());
            this.dmsMeetingInfoMapper.insertSelective(dmsMeetingInfo);
        } else {
            dmsMeetingInfo.setUpdateBy(SecurityUtils.getUsername());
            dmsMeetingInfo.setUpdateTime(new Date());
            this.dmsMeetingInfoMapper.updateByPrimaryKeySelective(dmsMeetingInfo);
        }
    }

    @Override
    public void deleteMeetingInfo(AdminDmsMeetingDto.DeleteMeetingInfo dto) {
        DmsMeetingInfoExample dmsMeetingExample = new DmsMeetingInfoExample();
        dmsMeetingExample.createCriteria().andIdIn((List)dto.getIdList());
        DmsMeetingInfo dmsMeeting = new DmsMeetingInfo();
        dmsMeeting.setDelFlag((byte)1);
        this.dmsMeetingInfoMapper.updateByExampleSelective(dmsMeeting, dmsMeetingExample);
    }

    @Override
    public void addMeetingUser(Long meetingId, List<String> usernameList) {
        DmsMeetingUserExample dmsMeetingUserExample = new DmsMeetingUserExample();
        dmsMeetingUserExample.createCriteria().andMeetingIdEqualTo(meetingId);
        DmsMeetingUser dmsMeetingUser = new DmsMeetingUser();
        dmsMeetingUser.setDelFlag((byte)1);
        this.dmsMeetingUserMapper.updateByExampleSelective(dmsMeetingUser, dmsMeetingUserExample);
        for (String username : usernameList) {
            DmsMeetingUser dmsMeetingUser1 = new DmsMeetingUser();
            dmsMeetingUser1.setId(IdUtil.getSnowflakeNextId());
            dmsMeetingUser1.setMeetingId(meetingId);
            dmsMeetingUser1.setUsername(username);
            dmsMeetingUser1.setCreateBy(SecurityUtils.getUsername());
            dmsMeetingUser1.setCreateTime(new Date());
            this.dmsMeetingUserMapper.insertSelective(dmsMeetingUser1);
        }
    }

    private void buildTree(DmsMeetingVo.DmsMeetingDetail.DmsMeetingInfoVo parent, List<DmsMeetingVo.DmsMeetingDetail.DmsMeetingInfoVo> allMeetingInfo) {
        ArrayList<DmsMeetingVo.DmsMeetingDetail.DmsMeetingInfoVo> children = new ArrayList<DmsMeetingVo.DmsMeetingDetail.DmsMeetingInfoVo>();
        for (DmsMeetingVo.DmsMeetingDetail.DmsMeetingInfoVo info : allMeetingInfo) {
            if (!info.getParentId().equals(parent.getId())) continue;
            children.add(info);
        }
        parent.setInfos(children);
        for (DmsMeetingVo.DmsMeetingDetail.DmsMeetingInfoVo child : children) {
            this.buildTree(child, allMeetingInfo);
        }
    }
}

