/*
 * Decompiled with CFR 0.152.
 */
package com.datangMeeting.web.controller.system;

import com.datangMeeting.common.annotation.Anonymous;
import com.datangMeeting.common.annotation.Log;
import com.datangMeeting.common.core.controller.BaseController;
import com.datangMeeting.common.core.domain.AjaxResult;
import com.datangMeeting.common.core.page.TableDataInfo;
import com.datangMeeting.common.enums.BusinessType;
import com.datangMeeting.common.utils.poi.ExcelUtil;
import com.datangMeeting.system.domain.SysConfig;
import com.datangMeeting.system.service.ISysConfigService;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system/config"})
public class SysConfigController
extends BaseController {
    @Autowired
    private ISysConfigService configService;

    @Anonymous
    @GetMapping(value={"/list"})
    public TableDataInfo list(SysConfig config) {
        this.startPage();
        List list = this.configService.selectConfigList(config);
        return this.getDataTable(list);
    }

    @Log(title="\u53c2\u6570\u7ba1\u7406", businessType=BusinessType.EXPORT)
    @PreAuthorize(value="@ss.hasPermi('system:config:export')")
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, SysConfig config) {
        List list = this.configService.selectConfigList(config);
        ExcelUtil util = new ExcelUtil(SysConfig.class);
        util.exportExcel(response, list, "\u53c2\u6570\u6570\u636e");
    }

    @PreAuthorize(value="@ss.hasPermi('system:config:query')")
    @GetMapping(value={"/{configId}"})
    public AjaxResult getInfo(@PathVariable Long configId) {
        return this.success((Object)this.configService.selectConfigById(configId));
    }

    @GetMapping(value={"/configKey/{configKey}"})
    public AjaxResult getConfigKey(@PathVariable String configKey) {
        return this.success(this.configService.selectConfigByKey(configKey));
    }

    @PreAuthorize(value="@ss.hasPermi('system:config:add')")
    @Log(title="\u53c2\u6570\u7ba1\u7406", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@Validated @RequestBody SysConfig config) {
        if (!this.configService.checkConfigKeyUnique(config)) {
            return this.error("\u65b0\u589e\u53c2\u6570'" + config.getConfigName() + "'\u5931\u8d25\uff0c\u53c2\u6570\u952e\u540d\u5df2\u5b58\u5728");
        }
        config.setCreateBy(this.getUsername());
        return this.toAjax(this.configService.insertConfig(config));
    }

    @PreAuthorize(value="@ss.hasPermi('system:config:edit')")
    @Log(title="\u53c2\u6570\u7ba1\u7406", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@Validated @RequestBody SysConfig config) {
        if (!this.configService.checkConfigKeyUnique(config)) {
            return this.error("\u4fee\u6539\u53c2\u6570'" + config.getConfigName() + "'\u5931\u8d25\uff0c\u53c2\u6570\u952e\u540d\u5df2\u5b58\u5728");
        }
        config.setUpdateBy(this.getUsername());
        return this.toAjax(this.configService.updateConfig(config));
    }

    @PreAuthorize(value="@ss.hasPermi('system:config:remove')")
    @Log(title="\u53c2\u6570\u7ba1\u7406", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{configIds}"})
    public AjaxResult remove(@PathVariable Long[] configIds) {
        this.configService.deleteConfigByIds(configIds);
        return this.success();
    }

    @PreAuthorize(value="@ss.hasPermi('system:config:remove')")
    @Log(title="\u53c2\u6570\u7ba1\u7406", businessType=BusinessType.CLEAN)
    @DeleteMapping(value={"/refreshCache"})
    public AjaxResult refreshCache() {
        this.configService.resetConfigCache();
        return this.success();
    }
}

