/*
 * Decompiled with CFR 0.152.
 */
package com.datangMeeting.system.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.datangMeeting.common.utils.SecurityUtils;
import com.datangMeeting.system.domain.dto.DmsMeetingDto;
import com.datangMeeting.system.domain.po.DmsMeeting;
import com.datangMeeting.system.domain.po.DmsMeetingInfoExample;
import com.datangMeeting.system.domain.vo.DmsMeetingVo;
import com.datangMeeting.system.persist.dao.DmsMeetingDao;
import com.datangMeeting.system.persist.mapper.DmsMeetingMapper;
import com.datangMeeting.system.service.DmsMeetingService;
import com.datangMeeting.system.service.ISysConfigService;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DmsMeetingServiceImpl
implements DmsMeetingService {
    @Resource
    private DmsMeetingDao meetingDao;
    @Resource
    private DmsMeetingMapper dmsMeetingMapper;
    @Resource
    private ISysConfigService configService;
    public static final String MEETING_KEY = "dms.meeting";

    @Override
    public List<DmsMeetingVo.CustomerMeeting> list(DmsMeetingDto.QueryMeeting dto) {
        List<DmsMeetingVo.DmsMeetingResultVo> list = this.meetingDao.list(null, SecurityUtils.getUserId(), SecurityUtils.getUsername(), (Date)DateUtil.parse((CharSequence)DateUtil.today(), (String)"yyyy-MM-dd"));
        if (CollUtil.isEmpty(list)) {
            return CollUtil.newArrayList((Object[])new DmsMeetingVo.CustomerMeeting[0]);
        }
        String configTitle = this.configService.selectConfigByKey(MEETING_KEY);
        Map<Date, List<DmsMeetingVo.DmsMeetingResultVo>> map = list.stream().collect(Collectors.groupingBy(DmsMeetingVo.DmsMeetingResultVo::getTimeGroupBy));
        ArrayList<DmsMeetingVo.CustomerMeeting> result = new ArrayList<DmsMeetingVo.CustomerMeeting>();
        for (Map.Entry<Date, List<DmsMeetingVo.DmsMeetingResultVo>> entry : map.entrySet()) {
            List<DmsMeetingVo.DmsMeetingResultVo> value = entry.getValue();
            DmsMeetingVo.CustomerMeeting customerMeeting = new DmsMeetingVo.CustomerMeeting();
            customerMeeting.setDateTitle(StrUtil.replace((CharSequence)configTitle, (CharSequence)"{date}", (CharSequence)DateUtil.format((Date)entry.getKey(), (String)"yyyy\u5e74MM\u6708dd\u65e5").trim()));
            ArrayList<DmsMeetingVo.CustomerMeeting.MeetingVo> meetingVoList = new ArrayList<DmsMeetingVo.CustomerMeeting.MeetingVo>();
            if (CollUtil.isNotEmpty(value)) {
                for (DmsMeetingVo.DmsMeetingResultVo dmsMeetingResultVo : value) {
                    DmsMeetingVo.CustomerMeeting.MeetingVo meetingVo = new DmsMeetingVo.CustomerMeeting.MeetingVo();
                    meetingVo.setId(dmsMeetingResultVo.getId());
                    meetingVo.setTitle(dmsMeetingResultVo.getTitle());
                    meetingVoList.add(meetingVo);
                }
            }
            customerMeeting.setMeetingList(meetingVoList);
            customerMeeting.setTime((Date)DateUtil.parse((CharSequence)DateUtil.format((Date)value.get(0).getTime(), (String)"yyyy-MM-dd")));
            result.add(customerMeeting);
        }
        return result.stream().sorted(Comparator.comparing(DmsMeetingVo.CustomerMeeting::getTime)).collect(Collectors.toList());
    }

    @Override
    public DmsMeetingVo.DmsMeetingDetail details(DmsMeetingDto.QueryMeetingDetail dto) {
        List<DmsMeetingVo.DmsMeetingDetail.DmsMeetingInfoVo> dmsMeetingInfoVos;
        DmsMeeting dmsMeeting = this.dmsMeetingMapper.selectByPrimaryKey(dto.getMeetingId());
        if (dmsMeeting == null) {
            return new DmsMeetingVo.DmsMeetingDetail();
        }
        DmsMeetingVo.DmsMeetingDetail dmsMeetingDetail = (DmsMeetingVo.DmsMeetingDetail)BeanUtil.copyProperties((Object)dmsMeeting, DmsMeetingVo.DmsMeetingDetail.class, (String[])new String[0]);
        DmsMeetingInfoExample dmsMeetingInfoExample = new DmsMeetingInfoExample();
        DmsMeetingInfoExample.Criteria criteria = dmsMeetingInfoExample.createCriteria().andDelFlagEqualTo((byte)0);
        if (dto.getMeetingId() != null) {
            criteria.andMeetingIdEqualTo(dto.getMeetingId());
        }
        if (CollUtil.isEmpty(dmsMeetingInfoVos = this.meetingDao.queryInfo(dto.getMeetingId()))) {
            return dmsMeetingDetail;
        }
        ArrayList<DmsMeetingVo.DmsMeetingDetail.DmsMeetingInfoVo> rootNodes = new ArrayList<DmsMeetingVo.DmsMeetingDetail.DmsMeetingInfoVo>();
        for (DmsMeetingVo.DmsMeetingDetail.DmsMeetingInfoVo info : dmsMeetingInfoVos) {
            if (info.getParentId() != 0L) continue;
            rootNodes.add(info);
        }
        for (DmsMeetingVo.DmsMeetingDetail.DmsMeetingInfoVo rootNode : rootNodes) {
            this.buildTree(rootNode, dmsMeetingInfoVos);
        }
        dmsMeetingDetail.setInfos(rootNodes);
        return dmsMeetingDetail;
    }

    private void buildTree(DmsMeetingVo.DmsMeetingDetail.DmsMeetingInfoVo parent, List<DmsMeetingVo.DmsMeetingDetail.DmsMeetingInfoVo> allMeetingInfo) {
        ArrayList<DmsMeetingVo.DmsMeetingDetail.DmsMeetingInfoVo> children = new ArrayList<DmsMeetingVo.DmsMeetingDetail.DmsMeetingInfoVo>();
        for (DmsMeetingVo.DmsMeetingDetail.DmsMeetingInfoVo info : allMeetingInfo) {
            if (!info.getParentId().equals(parent.getId())) continue;
            children.add(info);
        }
        parent.setInfos(children);
        for (DmsMeetingVo.DmsMeetingDetail.DmsMeetingInfoVo child : children) {
            this.buildTree(child, allMeetingInfo);
        }
    }
}

